/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.spawning;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import lotr.common.LOTRConfig;
import lotr.common.LOTRSpawnDamping;
import lotr.common.entity.animal.LOTRAnimalSpawnConditions;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.biome.variant.LOTRBiomeVariant;
import lotr.common.world.spawning.LOTRSpawnerNPCs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.event.ForgeEventFactory;

public class LOTRSpawnerAnimals {
    private static Set<ChunkCoordIntPair> eligibleSpawnChunks = new HashSet<ChunkCoordIntPair>();
    private static Map<Integer, Integer> ticksSinceCycle = new HashMap<Integer, Integer>();
    private static Map<Integer, DimInfo> dimInfos = new HashMap<Integer, DimInfo>();

    private static TypeInfo forDimAndType(World world, EnumCreatureType type) {
        TypeInfo typeInfo;
        int dimID = world.field_73011_w.field_76574_g;
        DimInfo dimInfo = dimInfos.get(dimID);
        if (dimInfo == null) {
            dimInfo = new DimInfo();
            dimInfos.put(dimID, dimInfo);
        }
        if ((typeInfo = dimInfo.types.get(type)) == null) {
            typeInfo = new TypeInfo();
            dimInfo.types.put(type, typeInfo);
        }
        return typeInfo;
    }

    public static int performSpawning(WorldServer world, boolean hostiles, boolean peacefuls, boolean rareTick) {
        int interval;
        int n = interval = rareTick ? 0 : LOTRConfig.mobSpawnInterval;
        if (interval > 0) {
            int ticks = 0;
            int dimID = world.field_73011_w.field_76574_g;
            if (ticksSinceCycle.containsKey(dimID)) {
                ticks = ticksSinceCycle.get(dimID);
            }
            ticksSinceCycle.put(dimID, --ticks);
            if (ticks > 0) {
                return 0;
            }
            ticks = interval;
            ticksSinceCycle.put(dimID, ticks);
        }
        if (!hostiles && !peacefuls) {
            return 0;
        }
        int totalSpawned = 0;
        LOTRSpawnerNPCs.getSpawnableChunks((World)world, eligibleSpawnChunks);
        ChunkCoordinates spawnPoint = world.func_72861_E();
        block2: for (EnumCreatureType creatureType : EnumCreatureType.values()) {
            int maxCount;
            int count;
            TypeInfo typeInfo = LOTRSpawnerAnimals.forDimAndType((World)world, creatureType);
            boolean canSpawnType = true;
            boolean bl = canSpawnType = creatureType.func_75599_d() ? peacefuls : hostiles;
            if (creatureType.func_82705_e()) {
                canSpawnType = rareTick;
            }
            if (!canSpawnType || (count = world.countEntities(creatureType, true)) > (maxCount = LOTRSpawnDamping.getCreatureSpawnCap(creatureType, (World)world) * eligibleSpawnChunks.size() / 196)) continue;
            int cycles = Math.max(1, interval);
            for (int c = 0; c < cycles; ++c) {
                if (typeInfo.blockedCycles > 0) {
                    --typeInfo.blockedCycles;
                    continue;
                }
                int newlySpawned = 0;
                List<ChunkCoordIntPair> shuffled = LOTRSpawnerNPCs.shuffle(eligibleSpawnChunks);
                block4: for (ChunkCoordIntPair chunkCoords : shuffled) {
                    int k;
                    int j;
                    int i;
                    ChunkPosition chunkposition = LOTRSpawnerNPCs.getRandomSpawningPointInChunk((World)world, chunkCoords);
                    if (chunkposition == null || world.func_73057_a(creatureType, i = chunkposition.field_151329_a, j = chunkposition.field_151327_b, k = chunkposition.field_151328_c) == null || world.func_147439_a(i, j, k).func_149721_r() || world.func_147439_a(i, j, k).func_149688_o() != creatureType.func_75600_c()) continue;
                    for (int groupsSpawned = 0; groupsSpawned < 3; ++groupsSpawned) {
                        int i1 = i;
                        int j1 = j;
                        int k1 = k;
                        int range = 6;
                        BiomeGenBase.SpawnListEntry spawnEntry = null;
                        IEntityLivingData entityData = null;
                        for (int attempts = 0; attempts < 4; ++attempts) {
                            EntityLiving entity;
                            float f5;
                            float f;
                            float f4;
                            float f2;
                            float f3;
                            float f6;
                            float f22;
                            float f1;
                            float f7;
                            if (!world.func_72899_e(i1 += world.field_73012_v.nextInt(range) - world.field_73012_v.nextInt(range), j1 += world.field_73012_v.nextInt(1) - world.field_73012_v.nextInt(1), k1 += world.field_73012_v.nextInt(range) - world.field_73012_v.nextInt(range)) || !SpawnerAnimals.func_77190_a((EnumCreatureType)creatureType, (World)world, (int)i1, (int)j1, (int)k1) || world.func_72977_a((double)(f7 = (float)i1 + 0.5f), (double)(f1 = (float)j1), (double)(f22 = (float)k1 + 0.5f), 24.0) != null || f6 * (f3 = f7 - (float)spawnPoint.field_71574_a) + f2 * (f4 = f1 - (float)spawnPoint.field_71572_b) + f * (f5 = f22 - (float)spawnPoint.field_71573_c) < 576.0f) continue;
                            if (spawnEntry == null && (spawnEntry = world.func_73057_a(creatureType, i1, j1, k1)) == null) continue block4;
                            try {
                                entity = (EntityLiving)spawnEntry.field_76300_b.getConstructor(World.class).newInstance(world);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                return totalSpawned;
                            }
                            entity.func_70012_b((double)f7, (double)f1, (double)f22, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                            Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entity, (World)world, (float)f7, (float)f1, (float)f22);
                            if (canSpawn != Event.Result.ALLOW && (canSpawn != Event.Result.DEFAULT || !entity.func_70601_bi())) continue;
                            ++totalSpawned;
                            world.func_72838_d((Entity)entity);
                            if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)entity, (World)world, (float)f7, (float)f1, (float)f22)) {
                                entityData = entity.func_110161_a(entityData);
                            }
                            ++newlySpawned;
                            if (c > 0 && ++count > maxCount) continue block2;
                            if (groupsSpawned >= ForgeEventFactory.getMaxSpawnPackSize((EntityLiving)entity)) continue block4;
                        }
                    }
                }
                if (newlySpawned == 0) {
                    ++typeInfo.failedCycles;
                    if (typeInfo.failedCycles < 10) continue;
                    typeInfo.failedCycles = 0;
                    typeInfo.blockedCycles = 100;
                    continue;
                }
                if (typeInfo.failedCycles <= 0) continue;
                --typeInfo.failedCycles;
            }
        }
        return totalSpawned;
    }

    public static void worldGenSpawnAnimals(World world, LOTRBiome biome, LOTRBiomeVariant variant, int i, int k, Random rand) {
        int spawnRange = 16;
        int spawnFuzz = 5;
        List spawnList = biome.func_76747_a(EnumCreatureType.creature);
        if (!spawnList.isEmpty()) {
            while (rand.nextFloat() < biome.func_76741_f()) {
                BiomeGenBase.SpawnListEntry spawnEntry = (BiomeGenBase.SpawnListEntry)WeightedRandom.func_76271_a((Random)world.field_73012_v, (Collection)spawnList);
                int count = MathHelper.func_76136_a((Random)rand, (int)spawnEntry.field_76301_c, (int)spawnEntry.field_76299_d);
                IEntityLivingData entityData = null;
                int packX = i + rand.nextInt(spawnRange);
                int packZ = k + rand.nextInt(spawnRange);
                int i1 = packX;
                int k1 = packZ;
                for (int l = 0; l < count; ++l) {
                    int attempts = 4;
                    boolean spawned = false;
                    for (int a = 0; !spawned && a < attempts; ++a) {
                        int j1 = world.func_72825_h(i1, k1);
                        if (SpawnerAnimals.func_77190_a((EnumCreatureType)EnumCreatureType.creature, (World)world, (int)i1, (int)j1, (int)k1)) {
                            EntityLiving entity;
                            float f = (float)i1 + 0.5f;
                            float f1 = j1;
                            float f2 = (float)k1 + 0.5f;
                            try {
                                entity = (EntityLiving)spawnEntry.field_76300_b.getConstructor(World.class).newInstance(world);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                continue;
                            }
                            boolean canSpawn = true;
                            if (entity instanceof LOTRAnimalSpawnConditions && !((LOTRAnimalSpawnConditions)entity).canWorldGenSpawnAt(i1, j1, k1, biome, variant)) {
                                canSpawn = false;
                            }
                            if (canSpawn) {
                                entity.func_70012_b((double)f, (double)f1, (double)f2, rand.nextFloat() * 360.0f, 0.0f);
                                world.func_72838_d((Entity)entity);
                                entityData = entity.func_110161_a(entityData);
                                spawned = true;
                            }
                        }
                        i1 += rand.nextInt(spawnFuzz) - rand.nextInt(spawnFuzz);
                        k1 += rand.nextInt(spawnFuzz) - rand.nextInt(spawnFuzz);
                        while (i1 < i || i1 >= i + spawnRange || k1 < k || k1 >= k + spawnRange) {
                            i1 = packX + rand.nextInt(spawnFuzz) - rand.nextInt(spawnFuzz);
                            k1 = packZ + rand.nextInt(spawnFuzz) - rand.nextInt(spawnFuzz);
                        }
                    }
                }
            }
        }
    }

    private static class DimInfo {
        public Map<EnumCreatureType, TypeInfo> types = new HashMap<EnumCreatureType, TypeInfo>();

        private DimInfo() {
        }
    }

    private static class TypeInfo {
        public int failedCycles;
        public int blockedCycles;

        private TypeInfo() {
        }
    }
}

